
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `accessories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accessories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `qty` int(11) NOT NULL DEFAULT 0,
  `requestable` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(191) DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `min_amt` int(11) DEFAULT NULL,
  `manufacturer_id` int(11) DEFAULT NULL,
  `model_number` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accessories_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accessories` WRITE;
/*!40000 ALTER TABLE `accessories` DISABLE KEYS */;
/*!40000 ALTER TABLE `accessories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accessories_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accessories_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `accessory_id` int(11) DEFAULT NULL,
  `assigned_to` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `note` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accessories_users` WRITE;
/*!40000 ALTER TABLE `accessories_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `accessories_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `action_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `action_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action_type` varchar(191) NOT NULL,
  `target_id` int(11) DEFAULT NULL,
  `target_type` varchar(191) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `filename` text DEFAULT NULL,
  `item_type` varchar(191) NOT NULL,
  `item_id` int(11) NOT NULL,
  `expected_checkin` date DEFAULT NULL,
  `accepted_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `thread_id` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `accept_signature` varchar(100) DEFAULT NULL,
  `log_meta` text DEFAULT NULL,
  `action_date` datetime DEFAULT NULL,
  `stored_eula` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `action_logs_thread_id_index` (`thread_id`),
  KEY `action_logs_created_at_index` (`created_at`),
  KEY `action_logs_item_type_item_id_action_type_index` (`item_type`,`item_id`,`action_type`),
  KEY `action_logs_target_type_target_id_action_type_index` (`target_type`,`target_id`,`action_type`),
  KEY `action_logs_target_type_target_id_index` (`target_type`,`target_id`),
  KEY `action_logs_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `action_logs` WRITE;
/*!40000 ALTER TABLE `action_logs` DISABLE KEYS */;
INSERT INTO `action_logs` VALUES (3,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-28 13:02:35','2023-05-28 13:02:35',NULL,NULL,2,NULL,NULL,NULL,NULL),(7,1,'checkout',5,'App\\Models\\User',NULL,'Checked out on asset creation',NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-28 13:02:35','2023-05-28 13:02:35',NULL,NULL,2,NULL,NULL,'2023-05-28 15:02:35',NULL),(8,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-28 13:44:01','2023-05-28 13:44:01',NULL,NULL,2,NULL,'{\"requestable\":{\"old\":1,\"new\":false},\"expected_checkin\":{\"old\":null,\"new\":\"2023-05-31\"}}',NULL,NULL),(9,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-28 13:48:04','2023-05-28 13:48:04',NULL,NULL,2,NULL,'{\"status_id\":{\"old\":7,\"new\":\"12\"}}',NULL,NULL),(13,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-28 13:48:35','2023-05-28 13:48:35',NULL,NULL,2,NULL,'{\"requestable\":{\"old\":0,\"new\":true}}',NULL,NULL),(15,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-28 18:20:46','2023-05-28 18:20:46',NULL,NULL,2,NULL,'{\"image\":{\"old\":null,\"new\":\"asset-image-3-WOUpkeFC0s.jpg\"}}',NULL,NULL),(17,1,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-29 06:01:05','2023-05-29 06:01:05',NULL,NULL,2,NULL,'{\"supplier_id\":{\"old\":null,\"new\":\"2\"}}',NULL,NULL),(21,5,'checkin from',5,'App\\Models\\User',NULL,'Test voor Plannend Check-out',NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-29 06:05:50','2023-05-29 06:05:50',NULL,NULL,2,NULL,NULL,'2023-05-29 08:05:50',NULL),(25,1,'checkout',5,'App\\Models\\Location',5,'',NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-29 06:19:26','2023-05-29 06:19:26',NULL,NULL,NULL,NULL,NULL,'2023-05-29 08:19:26',NULL),(29,1,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',5,NULL,NULL,'2023-05-29 06:21:25','2023-05-29 06:21:25',NULL,NULL,2,NULL,NULL,NULL,NULL),(30,1,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',5,NULL,NULL,'2023-05-29 06:22:23','2023-05-29 06:22:23',NULL,NULL,2,NULL,'{\"name\":{\"old\":null,\"new\":\"4-Port USB3.0 A>A Hub\"}}',NULL,NULL),(32,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-29 06:34:01','2023-05-29 06:34:01',NULL,NULL,2,NULL,'{\"_snipeit_test_1_5\":{\"old\":null,\"new\":\"2023-05-31\"}}',NULL,NULL),(35,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-29 06:46:27','2023-05-29 06:46:27',NULL,NULL,2,NULL,'{\"status_id\":{\"old\":7,\"new\":\"12\"}}',NULL,NULL),(36,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-29 06:48:45','2023-05-29 06:48:45',NULL,NULL,2,NULL,'{\"status_id\":{\"old\":12,\"new\":\"7\"}}',NULL,NULL),(38,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-29 06:50:31','2023-05-29 06:50:31',NULL,NULL,2,NULL,'{\"status_id\":{\"old\":7,\"new\":\"24\"}}',NULL,NULL),(42,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',5,NULL,NULL,'2023-05-29 07:17:02','2023-05-29 07:17:02',NULL,NULL,2,NULL,'{\"requestable\":{\"old\":0,\"new\":true},\"byod\":{\"old\":0,\"new\":\"1\"}}',NULL,NULL),(45,5,'checkin from',5,'App\\Models\\Location',NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-29 07:18:25','2023-05-29 07:18:25',NULL,NULL,NULL,NULL,NULL,'2023-05-21 00:00:00',NULL),(49,NULL,'requested',6,'App\\Models\\User',13,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-29 08:16:22','2023-05-29 08:16:22',NULL,NULL,2,NULL,NULL,NULL,NULL),(53,6,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-05-29 08:16:22','2023-05-29 08:16:22',NULL,NULL,2,NULL,'{\"requests_counter\":{\"old\":0,\"new\":1}}',NULL,NULL),(55,5,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',7,NULL,NULL,'2023-11-13 01:08:55','2023-11-13 01:08:55',NULL,NULL,2,NULL,NULL,NULL,NULL),(57,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',7,NULL,NULL,'2023-11-13 01:10:35','2023-11-13 01:10:35',NULL,NULL,2,NULL,'{\"company_id\":{\"old\":2,\"new\":\"5\"}}',NULL,NULL),(61,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',7,NULL,NULL,'2023-11-13 21:17:44','2023-11-13 21:17:44',NULL,NULL,5,NULL,'{\"asset_tag\":{\"old\":\"CC-00000003\",\"new\":\"CC-000003\"}}',NULL,NULL),(65,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',3,NULL,NULL,'2023-11-13 21:18:03','2023-11-13 21:18:03',NULL,NULL,2,NULL,'{\"asset_tag\":{\"old\":\"CC-00001\",\"new\":\"CC-000001\"},\"location_id\":{\"old\":13,\"new\":\"2\"}}',NULL,NULL),(68,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',5,NULL,NULL,'2023-11-13 21:18:15','2023-11-13 21:18:15',NULL,NULL,2,NULL,'{\"asset_tag\":{\"old\":\"CC-00002\",\"new\":\"CC-000002\"}}',NULL,NULL),(72,5,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',8,NULL,NULL,'2023-11-17 00:18:42','2023-11-17 00:18:42',NULL,NULL,2,NULL,NULL,NULL,NULL),(75,5,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',11,NULL,NULL,'2023-11-17 00:23:55','2023-11-17 00:23:55',NULL,NULL,2,NULL,NULL,NULL,NULL),(77,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',11,NULL,NULL,'2023-11-17 00:27:32','2023-11-17 00:27:32',NULL,NULL,2,NULL,'{\"purchase_cost\":{\"old\":\"199290.00\",\"new\":1992.90000000000009094947017729282379150390625}}',NULL,NULL),(81,5,'update',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Asset',8,NULL,NULL,'2023-11-17 00:27:48','2023-11-17 00:27:48',NULL,NULL,2,NULL,'{\"purchase_cost\":{\"old\":\"2686.00\",\"new\":26.8599999999999994315658113919198513031005859375}}',NULL,NULL),(82,5,'create',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Component',2,NULL,NULL,'2023-11-17 00:30:16','2023-11-17 00:30:16',NULL,NULL,2,NULL,NULL,NULL,NULL),(83,5,'delete',NULL,NULL,NULL,NULL,NULL,'App\\Models\\Component',2,NULL,NULL,'2023-11-17 00:31:58','2023-11-17 00:31:58',NULL,NULL,2,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `action_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action_type` varchar(191) NOT NULL,
  `asset_id` int(11) NOT NULL,
  `checkedout_to` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `asset_type` varchar(100) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `filename` text DEFAULT NULL,
  `requested_at` datetime DEFAULT NULL,
  `accepted_at` datetime DEFAULT NULL,
  `accessory_id` int(11) DEFAULT NULL,
  `accepted_id` int(11) DEFAULT NULL,
  `consumable_id` int(11) DEFAULT NULL,
  `expected_checkin` date DEFAULT NULL,
  `component_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_logs` WRITE;
/*!40000 ALTER TABLE `asset_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_maintenances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_maintenances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL,
  `supplier_id` int(10) unsigned NOT NULL,
  `asset_maintenance_type` varchar(191) NOT NULL,
  `title` varchar(100) NOT NULL,
  `is_warranty` tinyint(1) NOT NULL,
  `start_date` date NOT NULL,
  `completion_date` date DEFAULT NULL,
  `asset_maintenance_time` int(11) DEFAULT NULL,
  `notes` longtext DEFAULT NULL,
  `cost` decimal(20,2) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_maintenances` WRITE;
/*!40000 ALTER TABLE `asset_maintenances` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_maintenances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_uploads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `filename` varchar(191) NOT NULL,
  `asset_id` int(11) NOT NULL,
  `filenotes` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_uploads` WRITE;
/*!40000 ALTER TABLE `asset_uploads` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_uploads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `asset_tag` varchar(191) DEFAULT NULL,
  `model_id` int(11) DEFAULT NULL,
  `serial` varchar(191) DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `asset_eol_date` date DEFAULT NULL,
  `eol_explicit` tinyint(1) NOT NULL DEFAULT 0,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(191) DEFAULT NULL,
  `assigned_to` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `image` text DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `physical` tinyint(1) NOT NULL DEFAULT 1,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `status_id` int(11) DEFAULT NULL,
  `archived` tinyint(1) DEFAULT 0,
  `warranty_months` int(11) DEFAULT NULL,
  `depreciate` tinyint(1) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `requestable` tinyint(4) NOT NULL DEFAULT 0,
  `rtd_location_id` int(11) DEFAULT NULL,
  `accepted` varchar(191) DEFAULT NULL,
  `last_checkout` datetime DEFAULT NULL,
  `last_checkin` datetime DEFAULT NULL,
  `expected_checkin` date DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `assigned_type` varchar(191) DEFAULT NULL,
  `last_audit_date` datetime DEFAULT NULL,
  `next_audit_date` date DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `checkin_counter` int(11) NOT NULL DEFAULT 0,
  `checkout_counter` int(11) NOT NULL DEFAULT 0,
  `requests_counter` int(11) NOT NULL DEFAULT 0,
  `byod` tinyint(1) DEFAULT 0,
  `_snipeit_test_1_5` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_rtd_location_id_index` (`rtd_location_id`),
  KEY `assets_assigned_type_assigned_to_index` (`assigned_type`,`assigned_to`),
  KEY `assets_created_at_index` (`created_at`),
  KEY `assets_deleted_at_status_id_index` (`deleted_at`,`status_id`),
  KEY `assets_deleted_at_model_id_index` (`deleted_at`,`model_id`),
  KEY `assets_deleted_at_assigned_type_assigned_to_index` (`deleted_at`,`assigned_type`,`assigned_to`),
  KEY `assets_deleted_at_supplier_id_index` (`deleted_at`,`supplier_id`),
  KEY `assets_deleted_at_location_id_index` (`deleted_at`,`location_id`),
  KEY `assets_deleted_at_rtd_location_id_index` (`deleted_at`,`rtd_location_id`),
  KEY `assets_deleted_at_asset_tag_index` (`deleted_at`,`asset_tag`),
  KEY `assets_deleted_at_name_index` (`deleted_at`,`name`),
  KEY `assets_serial_index` (`serial`),
  KEY `assets_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
INSERT INTO `assets` VALUES (3,'USB-C to USB-A converter','CC-000001',1,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,'asset-image-3-WOUpkeFC0s.jpg',1,'2023-05-28 13:02:35','2023-11-13 21:18:03',1,NULL,7,0,NULL,0,2,1,2,NULL,NULL,'2023-05-29 08:05:50',NULL,2,NULL,NULL,NULL,2,2,2,1,0,'2023-05-31'),(5,'4-Port USB3.0 A>A Hub','CC-000002',3,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,1,'2023-05-29 06:21:25','2023-11-13 21:18:15',1,NULL,7,0,NULL,0,NULL,1,2,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,2,0,0,0,1,NULL),(7,'the sssnake MC164 Multicore Bundle','CC-000003',7,NULL,'2023-11-05',NULL,0,235.00,NULL,NULL,NULL,'asset-image--qP9WcMRQeD.jpg',5,'2023-11-13 01:08:55','2023-11-13 21:17:44',1,NULL,3,0,1,0,6,0,13,NULL,NULL,NULL,NULL,5,NULL,NULL,NULL,13,0,0,0,1,NULL),(8,'Tally M5','CC-000004',10,'4C7525CB8554','2023-11-15',NULL,0,26.86,'1306082',NULL,NULL,'asset-image--2eJmlGemmg.webp',5,'2023-11-17 00:18:42','2023-11-17 00:27:48',1,NULL,7,0,NULL,0,10,0,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,0,0,0,0,NULL),(11,'FlighCase V1 ( Fae1 )','CC-000005',11,'CC-000005','2023-01-28',NULL,0,1992.90,NULL,NULL,NULL,NULL,5,'2023-11-17 00:23:55','2023-11-17 00:27:32',1,NULL,7,0,NULL,0,6,0,NULL,NULL,NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,0,0,0,0,NULL);
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `eula_text` longtext DEFAULT NULL,
  `use_default_eula` tinyint(1) NOT NULL DEFAULT 0,
  `require_acceptance` tinyint(1) NOT NULL DEFAULT 0,
  `category_type` varchar(191) DEFAULT 'asset',
  `checkin_email` tinyint(1) NOT NULL DEFAULT 0,
  `image` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (3,'Misc Software','2023-05-28 11:59:58','2023-05-28 12:52:48',NULL,'2023-05-28 12:52:48',NULL,0,0,'license',0,NULL),(5,'CC- Tech','2023-05-28 13:02:18','2023-05-28 13:02:18',1,NULL,NULL,0,0,'asset',0,NULL),(9,'Servers','2023-11-17 00:29:13','2023-11-17 00:29:13',NULL,NULL,NULL,0,0,'component',0,NULL);
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `checkout_acceptances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `checkout_acceptances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `checkoutable_type` varchar(191) NOT NULL,
  `checkoutable_id` bigint(20) unsigned NOT NULL,
  `assigned_to_id` int(11) DEFAULT NULL,
  `signature_filename` varchar(191) DEFAULT NULL,
  `accepted_at` timestamp NULL DEFAULT NULL,
  `declined_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `stored_eula` text DEFAULT NULL,
  `stored_eula_file` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checkout_acceptances_checkoutable_type_checkoutable_id_index` (`checkoutable_type`,`checkoutable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `checkout_acceptances` WRITE;
/*!40000 ALTER TABLE `checkout_acceptances` DISABLE KEYS */;
/*!40000 ALTER TABLE `checkout_acceptances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `checkout_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `checkout_requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `requestable_id` int(11) NOT NULL,
  `requestable_type` varchar(191) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `canceled_at` datetime DEFAULT NULL,
  `fulfilled_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `checkout_requests_user_id_requestable_id_requestable_type` (`user_id`,`requestable_id`,`requestable_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `checkout_requests` WRITE;
/*!40000 ALTER TABLE `checkout_requests` DISABLE KEYS */;
INSERT INTO `checkout_requests` VALUES (1,6,3,'App\\Models\\Asset',1,'2023-05-29 08:16:22','2023-05-29 08:16:22',NULL,NULL,NULL);
/*!40000 ALTER TABLE `checkout_requests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `companies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `fax` varchar(20) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `companies_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `companies` WRITE;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` VALUES (2,'CeltCast',NULL,NULL,NULL,'2023-05-28 12:53:51','2023-05-28 12:53:51','company-image--vJnRm8Hxqq.png'),(5,'Lea-Inc',NULL,NULL,NULL,'2023-11-13 01:10:08','2023-11-13 01:10:08',NULL),(6,'Tycho Werner BV',NULL,NULL,NULL,'2023-11-13 01:10:22','2023-11-13 01:10:22',NULL);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `components`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `components` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `qty` int(11) NOT NULL DEFAULT 1,
  `order_number` varchar(191) DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `min_amt` int(11) DEFAULT NULL,
  `serial` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `components_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `components` WRITE;
/*!40000 ALTER TABLE `components` DISABLE KEYS */;
INSERT INTO `components` VALUES (2,'CC-Stream01',9,NULL,2,5,6,1,NULL,'2023-01-28',NULL,'2023-11-17 00:30:16','2023-11-17 00:31:58','2023-11-17 00:31:58',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `components` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `components_assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `components_assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `assigned_qty` int(11) DEFAULT 1,
  `component_id` int(11) DEFAULT NULL,
  `asset_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `note` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `components_assets` WRITE;
/*!40000 ALTER TABLE `components_assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `components_assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `qty` int(11) NOT NULL DEFAULT 0,
  `requestable` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(191) DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `min_amt` int(11) DEFAULT NULL,
  `model_number` varchar(191) DEFAULT NULL,
  `manufacturer_id` int(11) DEFAULT NULL,
  `item_no` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `consumables_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumables` WRITE;
/*!40000 ALTER TABLE `consumables` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `consumables_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `consumables_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `consumable_id` int(11) DEFAULT NULL,
  `assigned_to` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `note` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `consumables_users` WRITE;
/*!40000 ALTER TABLE `consumables_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `consumables_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_field_custom_fieldset`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_field_custom_fieldset` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` int(11) NOT NULL,
  `custom_fieldset_id` int(11) NOT NULL,
  `order` int(11) NOT NULL,
  `required` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_field_custom_fieldset` WRITE;
/*!40000 ALTER TABLE `custom_field_custom_fieldset` DISABLE KEYS */;
INSERT INTO `custom_field_custom_fieldset` VALUES (3,3,3,1,0),(4,5,7,0,0);
/*!40000 ALTER TABLE `custom_field_custom_fieldset` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `format` varchar(191) NOT NULL,
  `element` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `field_values` text DEFAULT NULL,
  `field_encrypted` tinyint(1) NOT NULL DEFAULT 0,
  `db_column` varchar(191) DEFAULT NULL,
  `help_text` text DEFAULT NULL,
  `show_in_email` tinyint(1) NOT NULL DEFAULT 0,
  `is_unique` tinyint(1) DEFAULT 0,
  `display_in_user_view` tinyint(1) DEFAULT 0,
  `auto_add_to_fieldsets` tinyint(1) DEFAULT 0,
  `show_in_listview` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fields` WRITE;
/*!40000 ALTER TABLE `custom_fields` DISABLE KEYS */;
INSERT INTO `custom_fields` VALUES (5,'Test #1','date','text','2023-05-29 06:28:10','2023-05-29 06:34:17',5,'',0,'_snipeit_test_1_5','De Datum waarop Test',0,0,1,0,0);
/*!40000 ALTER TABLE `custom_fields` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fieldsets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fieldsets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fieldsets` WRITE;
/*!40000 ALTER TABLE `custom_fieldsets` DISABLE KEYS */;
INSERT INTO `custom_fieldsets` VALUES (7,'Test Setup','2023-05-29 06:28:25','2023-05-29 06:28:25',5);
/*!40000 ALTER TABLE `custom_fieldsets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `fax` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `manager_id` int(11) DEFAULT NULL,
  `notes` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `departments_company_id_index` (`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `departments` WRITE;
/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` VALUES (3,'Merch',NULL,NULL,1,2,NULL,1,NULL,'2023-05-28 12:55:28','2023-05-28 12:55:28',NULL,'department-image--ZFbqyI6FvQ.png'),(4,'Video',NULL,NULL,1,2,NULL,1,NULL,'2023-05-28 12:55:52','2023-05-28 12:55:52',NULL,'department-image--qGqtahkhin.png'),(5,'Foto',NULL,NULL,1,2,NULL,1,NULL,'2023-05-28 12:56:39','2023-05-28 12:56:39',NULL,'department-image--cSPZvfMR6c.png');
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `depreciations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `depreciations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `months` int(11) NOT NULL,
  `depreciation_min` decimal(8,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `depreciations` WRITE;
/*!40000 ALTER TABLE `depreciations` DISABLE KEYS */;
/*!40000 ALTER TABLE `depreciations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `imports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `imports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `file_path` varchar(191) NOT NULL,
  `filesize` int(11) NOT NULL,
  `import_type` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `header_row` text DEFAULT NULL,
  `first_row` text DEFAULT NULL,
  `field_map` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `imports` WRITE;
/*!40000 ALTER TABLE `imports` DISABLE KEYS */;
/*!40000 ALTER TABLE `imports` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits` WRITE;
/*!40000 ALTER TABLE `kits` DISABLE KEYS */;
INSERT INTO `kits` VALUES (1,'Stream + Tally','2023-11-17 00:30:42','2023-11-17 00:30:42');
/*!40000 ALTER TABLE `kits` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_accessories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_accessories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int(11) DEFAULT NULL,
  `accessory_id` int(11) DEFAULT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_accessories` WRITE;
/*!40000 ALTER TABLE `kits_accessories` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits_accessories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_consumables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_consumables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int(11) DEFAULT NULL,
  `consumable_id` int(11) DEFAULT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_consumables` WRITE;
/*!40000 ALTER TABLE `kits_consumables` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits_consumables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_licenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_licenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int(11) DEFAULT NULL,
  `license_id` int(11) DEFAULT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_licenses` WRITE;
/*!40000 ALTER TABLE `kits_licenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `kits_licenses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kits_models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `kits_models` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `kit_id` int(11) DEFAULT NULL,
  `model_id` int(11) DEFAULT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kits_models` WRITE;
/*!40000 ALTER TABLE `kits_models` DISABLE KEYS */;
INSERT INTO `kits_models` VALUES (4,1,10,2,NULL,NULL),(8,1,11,1,NULL,NULL);
/*!40000 ALTER TABLE `kits_models` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `license_seats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `license_seats` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `license_id` int(11) DEFAULT NULL,
  `assigned_to` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `asset_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `license_seats_license_id_index` (`license_id`),
  KEY `license_seats_assigned_to_license_id_index` (`assigned_to`,`license_id`),
  KEY `license_seats_asset_id_license_id_index` (`asset_id`,`license_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `license_seats` WRITE;
/*!40000 ALTER TABLE `license_seats` DISABLE KEYS */;
/*!40000 ALTER TABLE `license_seats` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `licenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `licenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `serial` text DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_cost` decimal(20,2) DEFAULT NULL,
  `order_number` varchar(50) DEFAULT NULL,
  `seats` int(11) NOT NULL DEFAULT 1,
  `notes` text DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `depreciation_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `license_name` varchar(120) DEFAULT NULL,
  `license_email` varchar(191) DEFAULT NULL,
  `depreciate` tinyint(1) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `expiration_date` date DEFAULT NULL,
  `purchase_order` varchar(191) DEFAULT NULL,
  `termination_date` date DEFAULT NULL,
  `maintained` tinyint(1) DEFAULT NULL,
  `reassignable` tinyint(1) NOT NULL DEFAULT 1,
  `company_id` int(10) unsigned DEFAULT NULL,
  `manufacturer_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `licenses_company_id_index` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `licenses` WRITE;
/*!40000 ALTER TABLE `licenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `licenses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `address2` varchar(191) DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `fax` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `ldap_ou` varchar(191) DEFAULT NULL,
  `manager_id` int(11) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `locations` WRITE;
/*!40000 ALTER TABLE `locations` DISABLE KEYS */;
INSERT INTO `locations` VALUES (2,'Tycho Werner',NULL,NULL,'NL','2023-05-28 12:59:50','2024-05-13 05:55:07',NULL,NULL,NULL,NULL,NULL,NULL,NULL,10,NULL,NULL,NULL,NULL),(5,'FantasyFest @ Broodfabriek Rijswijk','Rijswijk','Zuid-Holland','NL','2023-05-29 06:17:16','2023-05-29 06:53:24',1,'Volmerlaan 12',NULL,'2288GD',NULL,NULL,NULL,6,NULL,NULL,NULL,NULL),(6,'PAST-PROD',NULL,NULL,NULL,'2023-05-29 06:17:45','2023-05-29 06:40:37',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'location-image-6-QUVCRxfi7L.png'),(10,'CELTCASTERS',NULL,NULL,NULL,'2023-05-29 06:40:03','2023-05-29 06:40:03',5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'location-image--ScD734U50P.png'),(13,'Hannah Schotte','Oostvoorne','Zuid-Holland','NL','2023-05-29 06:55:02','2023-05-29 06:55:02',5,'Vrouwe Machteldweg 18',NULL,'3233TW',NULL,NULL,NULL,10,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `login_attempts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `login_attempts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(191) DEFAULT NULL,
  `remote_ip` varchar(45) DEFAULT NULL,
  `user_agent` varchar(191) DEFAULT NULL,
  `successful` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=135 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `login_attempts` WRITE;
/*!40000 ALTER TABLE `login_attempts` DISABLE KEYS */;
INSERT INTO `login_attempts` VALUES (1,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-05-28 12:23:05',NULL),(5,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:14:45',NULL),(9,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:14:56',NULL),(10,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-05-28 13:14:59',NULL),(14,'Tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:15:55',NULL),(18,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-05-28 13:16:16',NULL),(19,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:16:41',NULL),(22,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:17:03',NULL),(24,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:18:30',NULL),(27,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:18:40',NULL),(29,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:19:32',NULL),(31,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-05-28 13:20:23',NULL),(33,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:21:18',NULL),(35,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:21:29',NULL),(36,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:21:36',NULL),(39,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:21:41',NULL),(40,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-05-28 13:21:46',NULL),(44,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:25:02',NULL),(48,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-28 13:25:23',NULL),(51,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-05-28 13:25:28',NULL),(53,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-05-28 13:26:16',NULL),(56,'hschotte','109.36.155.37','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Mobile Safari/537.36',1,'2023-05-28 13:50:52',NULL),(57,'tycho_w','2a02:a456:b19c:1:f1cb:4ea0:4f2c:3ff3','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Mobile Safari/537.36',1,'2023-05-29 05:00:15',NULL),(58,'tycho_w','2a02:a456:b19c:1:1855:cefd:5eca:9c42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-29 05:56:29',NULL),(61,'tycho_w','2a02:a456:b19c:1:1855:cefd:5eca:9c42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-29 05:56:35',NULL),(62,'tycho.werner','2a02:a456:b19c:1:1855:cefd:5eca:9c42','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-05-29 05:56:39',NULL),(66,'hschotte','144.178.246.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-29 07:06:35',NULL),(69,'hschotte','144.178.246.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-29 07:06:41',NULL),(72,'hschotte','144.178.246.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',0,'2023-05-29 07:08:59',NULL),(74,'hschotte','144.178.246.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-05-29 07:14:31',NULL),(76,'debug','144.178.246.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36',1,'2023-05-29 07:25:09',NULL),(77,'debug','144.178.246.68','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',1,'2023-06-19 10:27:58',NULL),(79,'hannah','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',0,'2023-06-26 17:26:29',NULL),(81,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',1,'2023-06-26 17:27:21',NULL),(84,'hschotte','109.36.159.115','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Mobile Safari/537.36',1,'2023-06-26 20:00:45',NULL),(87,'hschotte','109.36.159.115','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Mobile Safari/537.36',1,'2023-06-26 20:01:12',NULL),(90,'hschotte','109.36.159.115','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Mobile Safari/537.36',1,'2023-06-26 20:02:02',NULL),(92,'hschotte','149.143.43.108','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Mobile Safari/537.36',1,'2023-06-26 20:14:54',NULL),(94,'tycho.werner','2a02:a420:45:71f4:ec49:9a6a:3daf:12c9','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Mobile Safari/537.36',1,'2023-06-27 13:53:07',NULL),(98,'debug','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',1,'2023-07-02 12:02:14',NULL),(99,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',1,'2023-07-09 17:49:16',NULL),(102,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',1,'2023-11-09 16:56:41',NULL),(105,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',1,'2023-11-09 16:56:43',NULL),(106,'hschotte','149.143.43.108','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Mobile Safari/537.36',1,'2023-11-12 09:45:04',NULL),(110,'debug','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',1,'2023-11-12 09:53:41',NULL),(112,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',1,'2023-11-12 09:57:08',NULL),(114,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',0,'2023-11-12 09:57:48',NULL),(115,'tycho_w','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',0,'2023-11-12 09:58:02',NULL),(118,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',1,'2023-11-12 09:58:40',NULL),(120,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',1,'2023-11-13 18:43:33',NULL),(123,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',1,'2023-11-13 20:14:35',NULL),(126,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',1,'2023-11-13 20:20:27',NULL),(129,'hschotte','149.143.43.108','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Mobile Safari/537.36',1,'2023-11-13 21:15:02',NULL),(131,'hschotte','149.143.43.108','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',1,'2023-11-16 23:55:33',NULL),(132,'hschotte','149.143.43.108','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Mobile Safari/537.36',1,'2023-11-23 21:41:52',NULL),(134,'tycho.werner','86.92.102.116','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36',1,'2024-05-13 05:52:35',NULL);
/*!40000 ALTER TABLE `login_attempts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `manufacturers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `manufacturers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `url` varchar(191) DEFAULT NULL,
  `support_url` varchar(191) DEFAULT NULL,
  `warranty_lookup_url` varchar(191) DEFAULT NULL,
  `support_phone` varchar(191) DEFAULT NULL,
  `support_email` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `manufacturers` WRITE;
/*!40000 ALTER TABLE `manufacturers` DISABLE KEYS */;
INSERT INTO `manufacturers` VALUES (4,'Lea-Inc','2023-11-17 00:19:56','2023-11-17 00:19:56',5,NULL,'https://lea-inc.nl','https://lea-inc.nl','https://lea-inc.nl','+31636446351','info@lea-inc.nl',NULL);
/*!40000 ALTER TABLE `manufacturers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1450 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (3,'2012_12_06_225921_migration_cartalyst_sentry_install_users',1),(7,'2012_12_06_225929_migration_cartalyst_sentry_install_groups',1),(11,'2012_12_06_225945_migration_cartalyst_sentry_install_users_groups_pivot',1),(15,'2012_12_06_225988_migration_cartalyst_sentry_install_throttle',1),(19,'2013_03_23_193214_update_users_table',1),(23,'2013_11_13_075318_create_models_table',1),(27,'2013_11_13_075335_create_categories_table',1),(31,'2013_11_13_075347_create_manufacturers_table',1),(35,'2013_11_15_015858_add_user_id_to_categories',1),(39,'2013_11_15_112701_add_user_id_to_manufacturers',1),(43,'2013_11_15_190327_create_assets_table',1),(47,'2013_11_15_190357_create_temp_licenses_table',1),(51,'2013_11_15_201848_add_license_name_to_licenses',1),(55,'2013_11_16_040323_create_depreciations_table',1),(59,'2013_11_16_042851_add_depreciation_id_to_models',1),(63,'2013_11_16_084923_add_user_id_to_models',1),(67,'2013_11_16_103258_create_locations_table',1),(71,'2013_11_16_103336_add_location_id_to_assets',1),(75,'2013_11_16_103407_add_checkedout_to_to_assets',1),(79,'2013_11_16_103425_create_history_table',1),(83,'2013_11_17_054359_drop_licenses_table',1),(87,'2013_11_17_054526_add_physical_to_assets',1),(91,'2013_11_17_055126_create_settings_table',1),(95,'2013_11_17_062634_add_license_to_assets',1),(99,'2013_11_18_134332_add_contacts_to_users',1),(103,'2013_11_18_142847_add_info_to_locations',1),(107,'2013_11_18_152942_remove_location_id_from_asset',1),(111,'2013_11_18_164423_set_nullvalues_for_user',1),(115,'2013_11_19_013337_create_asset_logs_table',1),(119,'2013_11_19_061409_edit_added_on_asset_logs_table',1),(123,'2013_11_19_062250_edit_location_id_asset_logs_table',1),(127,'2013_11_20_055822_add_soft_delete_on_assets',1),(131,'2013_11_20_121404_add_soft_delete_on_locations',1),(135,'2013_11_20_123137_add_soft_delete_on_manufacturers',1),(139,'2013_11_20_123725_add_soft_delete_on_categories',1),(143,'2013_11_20_130248_create_status_labels',1),(147,'2013_11_20_130830_add_status_id_on_assets_table',1),(151,'2013_11_20_131544_add_status_type_on_status_labels',1),(155,'2013_11_20_134103_add_archived_to_assets',1),(159,'2013_11_21_002321_add_uploads_table',1),(163,'2013_11_21_024531_remove_deployable_boolean_from_status_labels',1),(167,'2013_11_22_075308_add_option_label_to_settings_table',1),(171,'2013_11_22_213400_edits_to_settings_table',1),(175,'2013_11_25_013244_recreate_licenses_table',1),(179,'2013_11_25_031458_create_license_seats_table',1),(183,'2013_11_25_032022_add_type_to_actionlog_table',1),(187,'2013_11_25_033008_delete_bad_licenses_table',1),(191,'2013_11_25_033131_create_new_licenses_table',1),(195,'2013_11_25_033534_add_licensed_to_licenses_table',1),(199,'2013_11_25_101308_add_warrantee_to_assets_table',1),(203,'2013_11_25_104343_alter_warranty_column_on_assets',1),(207,'2013_11_25_150450_drop_parent_from_categories',1),(211,'2013_11_25_151920_add_depreciate_to_assets',1),(215,'2013_11_25_152903_add_depreciate_to_licenses_table',1),(219,'2013_11_26_211820_drop_license_from_assets_table',1),(223,'2013_11_27_062510_add_note_to_asset_logs_table',1),(227,'2013_12_01_113426_add_filename_to_asset_log',1),(231,'2013_12_06_094618_add_nullable_to_licenses_table',1),(235,'2013_12_10_084038_add_eol_on_models_table',1),(239,'2013_12_12_055218_add_manager_to_users_table',1),(243,'2014_01_28_031200_add_qr_code_to_settings_table',1),(247,'2014_02_13_183016_add_qr_text_to_settings_table',1),(251,'2014_05_24_093839_alter_default_license_depreciation_id',1),(255,'2014_05_27_231658_alter_default_values_licenses',1),(259,'2014_06_19_191508_add_asset_name_to_settings',1),(263,'2014_06_20_004847_make_asset_log_checkedout_to_nullable',1),(267,'2014_06_20_005050_make_asset_log_purchasedate_to_nullable',1),(271,'2014_06_24_003011_add_suppliers',1),(275,'2014_06_24_010742_add_supplier_id_to_asset',1),(279,'2014_06_24_012839_add_zip_to_supplier',1),(283,'2014_06_24_033908_add_url_to_supplier',1),(287,'2014_07_08_054116_add_employee_id_to_users',1),(291,'2014_07_09_134316_add_requestable_to_assets',1),(295,'2014_07_17_085822_add_asset_to_software',1),(299,'2014_07_17_161625_make_asset_id_in_logs_nullable',1),(303,'2014_08_12_053504_alpha_0_4_2_release',1),(307,'2014_08_17_083523_make_location_id_nullable',1),(311,'2014_10_16_200626_add_rtd_location_to_assets',1),(315,'2014_10_24_000417_alter_supplier_state_to_32',1),(319,'2014_10_24_015641_add_display_checkout_date',1),(323,'2014_10_28_222654_add_avatar_field_to_users_table',1),(327,'2014_10_29_045924_add_image_field_to_models_table',1),(331,'2014_11_01_214955_add_eol_display_to_settings',1),(335,'2014_11_04_231416_update_group_field_for_reporting',1),(339,'2014_11_05_212408_add_fields_to_licenses',1),(343,'2014_11_07_021042_add_image_to_supplier',1),(347,'2014_11_20_203007_add_username_to_user',1),(351,'2014_11_20_223947_add_auto_to_settings',1),(355,'2014_11_20_224421_add_prefix_to_settings',1),(359,'2014_11_21_104401_change_licence_type',1),(363,'2014_12_09_082500_add_fields_maintained_term_to_licenses',1),(367,'2015_02_04_155757_increase_user_field_lengths',1),(371,'2015_02_07_013537_add_soft_deleted_to_log',1),(375,'2015_02_10_040958_fix_bad_assigned_to_ids',1),(379,'2015_02_10_053310_migrate_data_to_new_statuses',1),(383,'2015_02_11_044104_migrate_make_license_assigned_null',1),(387,'2015_02_11_104406_migrate_create_requests_table',1),(391,'2015_02_12_001312_add_mac_address_to_asset',1),(395,'2015_02_12_024100_change_license_notes_type',1),(399,'2015_02_17_231020_add_localonly_to_settings',1),(403,'2015_02_19_222322_add_logo_and_colors_to_settings',1),(407,'2015_02_24_072043_add_alerts_to_settings',1),(411,'2015_02_25_022931_add_eula_fields',1),(415,'2015_02_25_204513_add_accessories_table',1),(419,'2015_02_26_091228_add_accessories_user_table',1),(423,'2015_02_26_115128_add_deleted_at_models',1),(427,'2015_02_26_233005_add_category_type',1),(431,'2015_03_01_231912_update_accepted_at_to_acceptance_id',1),(435,'2015_03_05_011929_add_qr_type_to_settings',1),(439,'2015_03_18_055327_add_note_to_user',1),(443,'2015_04_29_234704_add_slack_to_settings',1),(447,'2015_05_04_085151_add_parent_id_to_locations_table',1),(451,'2015_05_22_124421_add_reassignable_to_licenses',1),(455,'2015_06_10_003314_fix_default_for_user_notes',1),(459,'2015_06_10_003554_create_consumables',1),(463,'2015_06_15_183253_move_email_to_username',1),(467,'2015_06_23_070346_make_email_nullable',1),(471,'2015_06_26_213716_create_asset_maintenances_table',1),(475,'2015_07_04_212443_create_custom_fields_table',1),(479,'2015_07_09_014359_add_currency_to_settings_and_locations',1),(483,'2015_07_21_122022_add_expected_checkin_date_to_asset_logs',1),(487,'2015_07_24_093845_add_checkin_email_to_category_table',1),(491,'2015_07_25_055415_remove_email_unique_constraint',1),(495,'2015_07_29_230054_add_thread_id_to_asset_logs_table',1),(499,'2015_07_31_015430_add_accepted_to_assets',1),(503,'2015_09_09_195301_add_custom_css_to_settings',1),(507,'2015_09_21_235926_create_custom_field_custom_fieldset',1),(511,'2015_09_22_000104_create_custom_fieldsets',1),(515,'2015_09_22_003321_add_fieldset_id_to_assets',1),(519,'2015_09_22_003413_migrate_mac_address',1),(523,'2015_09_28_003314_fix_default_purchase_order',1),(527,'2015_10_01_024551_add_accessory_consumable_price_info',1),(531,'2015_10_12_192706_add_brand_to_settings',1),(535,'2015_10_22_003314_fix_defaults_accessories',1),(539,'2015_10_23_182625_add_checkout_time_and_expected_checkout_date_to_assets',1),(543,'2015_11_05_061015_create_companies_table',1),(547,'2015_11_05_061115_add_company_id_to_consumables_table',1),(551,'2015_11_05_183749_image',1),(555,'2015_11_06_092038_add_company_id_to_accessories_table',1),(559,'2015_11_06_100045_add_company_id_to_users_table',1),(563,'2015_11_06_134742_add_company_id_to_licenses_table',1),(567,'2015_11_08_035832_add_company_id_to_assets_table',1),(571,'2015_11_08_222305_add_ldap_fields_to_settings',1),(575,'2015_11_15_151803_add_full_multiple_companies_support_to_settings_table',1),(579,'2015_11_26_195528_import_ldap_settings',1),(583,'2015_11_30_191504_remove_fk_company_id',1),(587,'2015_12_21_193006_add_ldap_server_cert_ignore_to_settings_table',1),(591,'2015_12_30_233509_add_timestamp_and_userId_to_custom_fields',1),(595,'2015_12_30_233658_add_timestamp_and_userId_to_custom_fieldsets',1),(599,'2016_01_28_041048_add_notes_to_models',1),(603,'2016_02_19_070119_add_remember_token_to_users_table',1),(607,'2016_02_19_073625_create_password_resets_table',1),(611,'2016_03_02_193043_add_ldap_flag_to_users',1),(615,'2016_03_02_220517_update_ldap_filter_to_longer_field',1),(619,'2016_03_08_225351_create_components_table',1),(623,'2016_03_09_024038_add_min_stock_to_tables',1),(627,'2016_03_10_133849_add_locale_to_users',1),(631,'2016_03_10_135519_add_locale_to_settings',1),(635,'2016_03_11_185621_add_label_settings_to_settings',1),(639,'2016_03_22_125911_fix_custom_fields_regexes',1),(643,'2016_04_28_141554_add_show_to_users',1),(647,'2016_05_16_164733_add_model_mfg_to_consumable',1),(651,'2016_05_19_180351_add_alt_barcode_settings',1),(655,'2016_05_19_191146_add_alter_interval',1),(659,'2016_05_19_192226_add_inventory_threshold',1),(663,'2016_05_20_024859_remove_option_keys_from_settings_table',1),(667,'2016_05_20_143758_remove_option_value_from_settings_table',1),(671,'2016_06_01_000001_create_oauth_auth_codes_table',1),(675,'2016_06_01_000002_create_oauth_access_tokens_table',1),(679,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(683,'2016_06_01_000004_create_oauth_clients_table',1),(687,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(691,'2016_06_01_140218_add_email_domain_and_format_to_settings',1),(695,'2016_06_22_160725_add_user_id_to_maintenances',1),(699,'2016_07_13_150015_add_is_ad_to_settings',1),(703,'2016_07_14_153609_add_ad_domain_to_settings',1),(707,'2016_07_22_003348_fix_custom_fields_regex_stuff',1),(711,'2016_07_22_054850_one_more_mac_addr_fix',1),(715,'2016_07_22_143045_add_port_to_ldap_settings',1),(719,'2016_07_22_153432_add_tls_to_ldap_settings',1),(723,'2016_07_27_211034_add_zerofill_to_settings',1),(727,'2016_08_02_124944_add_color_to_statuslabel',1),(731,'2016_08_04_134500_add_disallow_ldap_pw_sync_to_settings',1),(735,'2016_08_09_002225_add_manufacturer_to_licenses',1),(739,'2016_08_12_121613_add_manufacturer_to_accessories_table',1),(743,'2016_08_23_143353_add_new_fields_to_custom_fields',1),(747,'2016_08_23_145619_add_show_in_nav_to_status_labels',1),(751,'2016_08_30_084634_make_purchase_cost_nullable',1),(755,'2016_09_01_141051_add_requestable_to_asset_model',1),(759,'2016_09_02_001448_create_checkout_requests_table',1),(763,'2016_09_04_180400_create_actionlog_table',1),(767,'2016_09_04_182149_migrate_asset_log_to_action_log',1),(771,'2016_09_19_235935_fix_fieldtype_for_target_type',1),(775,'2016_09_23_140722_fix_modelno_in_consumables_to_string',1),(779,'2016_09_28_231359_add_company_to_logs',1),(783,'2016_10_14_130709_fix_order_number_to_varchar',1),(787,'2016_10_16_015024_rename_modelno_to_model_number',1),(791,'2016_10_16_015211_rename_consumable_modelno_to_model_number',1),(795,'2016_10_16_143235_rename_model_note_to_notes',1),(799,'2016_10_16_165052_rename_component_total_qty_to_qty',1),(803,'2016_10_19_145520_fix_order_number_in_components_to_string',1),(807,'2016_10_27_151715_add_serial_to_components',1),(811,'2016_10_27_213251_increase_serial_field_capacity',1),(815,'2016_10_29_002724_enable_2fa_fields',1),(819,'2016_10_29_082408_add_signature_to_acceptance',1),(823,'2016_11_01_030818_fix_forgotten_filename_in_action_logs',1),(827,'2016_11_13_020954_rename_component_serial_number_to_serial',1),(831,'2016_11_16_172119_increase_purchase_cost_size',1),(835,'2016_11_17_161317_longer_state_field_in_location',1),(839,'2016_11_17_193706_add_model_number_to_accessories',1),(843,'2016_11_24_160405_add_missing_target_type_to_logs_table',1),(847,'2016_12_07_173720_increase_size_of_state_in_suppliers',1),(851,'2016_12_19_004212_adjust_locale_length_to_10',1),(855,'2016_12_19_133936_extend_phone_lengths_in_supplier_and_elsewhere',1),(859,'2016_12_27_212631_make_asset_assigned_to_polymorphic',1),(863,'2017_01_09_040429_create_locations_ldap_query_field',1),(867,'2017_01_14_002418_create_imports_table',1),(871,'2017_01_25_063357_fix_utf8_custom_field_column_names',1),(875,'2017_03_03_154632_add_time_date_display_to_settings',1),(879,'2017_03_10_210807_add_fields_to_manufacturer',1),(883,'2017_05_08_195520_increase_size_of_field_values_in_custom_fields',1),(887,'2017_05_22_204422_create_departments',1),(891,'2017_05_22_233509_add_manager_to_locations_table',1),(895,'2017_06_14_122059_add_next_autoincrement_to_settings',1),(899,'2017_06_18_151753_add_header_and_first_row_to_importer_table',1),(903,'2017_07_07_191533_add_login_text',1),(907,'2017_07_25_130710_add_thumbsize_to_settings',1),(911,'2017_08_03_160105_set_asset_archived_to_zero_default',1),(915,'2017_08_22_180636_add_secure_password_options',1),(919,'2017_08_25_074822_add_auditing_tables',1),(923,'2017_08_25_101435_add_auditing_to_settings',1),(927,'2017_09_18_225619_fix_assigned_type_not_being_nulled',1),(931,'2017_10_03_015503_drop_foreign_keys',1),(935,'2017_10_10_123504_allow_nullable_depreciation_id_in_models',1),(939,'2017_10_17_133709_add_display_url_to_settings',1),(943,'2017_10_19_120002_add_custom_forgot_password_url',1),(947,'2017_10_19_130406_add_image_and_supplier_to_accessories',1),(951,'2017_10_20_234129_add_location_indices_to_assets',1),(955,'2017_10_25_202930_add_images_uploads_to_locations_manufacturers_etc',1),(959,'2017_10_27_180947_denorm_asset_locations',1),(963,'2017_10_27_192423_migrate_denormed_asset_locations',1),(967,'2017_10_30_182938_add_address_to_user',1),(971,'2017_11_08_025918_add_alert_menu_setting',1),(975,'2017_11_08_123942_labels_display_company_name',1),(979,'2017_12_12_010457_normalize_asset_last_audit_date',1),(983,'2017_12_12_033618_add_actionlog_meta',1),(987,'2017_12_26_170856_re_normalize_last_audit',1),(991,'2018_01_17_184354_add_archived_in_list_setting',1),(995,'2018_01_19_203121_add_dashboard_message_to_settings',1),(999,'2018_01_24_062633_add_footer_settings_to_settings',1),(1003,'2018_01_24_093426_add_modellist_preferenc',1),(1007,'2018_02_22_160436_add_remote_user_settings',1),(1011,'2018_03_03_011032_add_theme_to_settings',1),(1015,'2018_03_06_054937_add_default_flag_on_statuslabels',1),(1019,'2018_03_23_212048_add_display_in_email_to_custom_fields',1),(1023,'2018_03_24_030738_add_show_images_in_email_setting',1),(1027,'2018_03_24_050108_add_cc_alerts',1),(1031,'2018_03_29_053618_add_canceled_at_and_fulfilled_at_in_requests',1),(1035,'2018_03_29_070121_add_drop_unique_requests',1),(1039,'2018_03_29_070511_add_new_index_requestable',1),(1043,'2018_04_02_150700_labels_display_model_name',1),(1047,'2018_04_16_133902_create_custom_field_default_values_table',1),(1051,'2018_05_04_073223_add_category_to_licenses',1),(1055,'2018_05_04_075235_add_update_license_category',1),(1059,'2018_05_08_031515_add_gdpr_privacy_footer',1),(1063,'2018_05_14_215229_add_indexes',1),(1067,'2018_05_14_223646_add_indexes_to_assets',1),(1071,'2018_05_14_233638_denorm_counters_on_assets',1),(1075,'2018_05_16_153409_add_first_counter_totals_to_assets',1),(1079,'2018_06_21_134622_add_version_footer',1),(1083,'2018_07_05_215440_add_unique_serial_option_to_settings',1),(1087,'2018_07_17_005911_create_login_attempts_table',1),(1091,'2018_07_24_154348_add_logo_to_print_assets',1),(1095,'2018_07_28_023826_create_checkout_acceptances_table',1),(1099,'2018_08_20_204842_add_depreciation_option_to_settings',1),(1103,'2018_09_10_082212_create_checkout_acceptances_for_unaccepted_assets',1),(1107,'2018_10_18_191228_add_kits_licenses_table',1),(1111,'2018_10_19_153910_add_kits_table',1),(1115,'2018_10_19_154013_add_kits_models_table',1),(1119,'2018_12_05_211936_add_favicon_to_settings',1),(1123,'2018_12_05_212119_add_email_logo_to_settings',1),(1127,'2019_02_07_185953_add_kits_consumables_table',1),(1131,'2019_02_07_190030_add_kits_accessories_table',1),(1135,'2019_02_12_182750_add_actiondate_to_actionlog',1),(1139,'2019_02_14_154310_change_auto_increment_prefix_to_nullable',1),(1143,'2019_02_16_143518_auto_increment_back_to_string',1),(1147,'2019_02_17_205048_add_label_logo_to_settings',1),(1151,'2019_02_20_234421_make_serial_nullable',1),(1155,'2019_02_21_224703_make_fields_nullable_for_integrity',1),(1159,'2019_04_06_060145_add_user_skin_setting',1),(1163,'2019_04_06_205355_add_setting_allow_user_skin',1),(1167,'2019_06_12_184327_rename_groups_table',1),(1171,'2019_07_23_140906_add_show_assigned_assets_to_settings',1),(1175,'2019_08_20_084049_add_custom_remote_user_header',1),(1179,'2019_12_04_223111_passport_upgrade',1),(1183,'2020_02_04_172100_add_ad_append_domain_settings',1),(1187,'2020_04_29_222305_add_saml_fields_to_settings',1),(1191,'2020_08_11_200712_add_saml_key_rollover',1),(1195,'2020_10_22_233743_move_accessory_checkout_note_to_join_table',1),(1199,'2020_10_23_161736_fix_zero_values_for_locations',1),(1203,'2020_11_18_214827_widen_license_serial_field',1),(1207,'2020_12_14_233815_add_digit_separator_to_settings',1),(1211,'2020_12_18_090026_swap_target_type_index_order',1),(1215,'2020_12_21_153235_update_min_password',1),(1219,'2020_12_21_210105_fix_bad_ldap_server_url_for_v5',1),(1223,'2021_02_05_172502_add_provider_to_oauth_table',1),(1227,'2021_03_18_184102_adds_several_ldap_fields',1),(1231,'2021_04_07_001811_add_ldap_dept',1),(1235,'2021_04_14_180125_add_ids_to_tables',1),(1239,'2021_06_07_155421_add_serial_number_indexes',1),(1243,'2021_06_07_155436_add_company_id_indexes',1),(1247,'2021_07_28_031345_add_client_side_l_d_a_p_cert_to_settings',1),(1251,'2021_07_28_040554_add_client_side_l_d_a_p_key_to_settings',1),(1255,'2021_08_11_005206_add_depreciation_minimum_value',1),(1259,'2021_08_24_124354_make_ldap_client_certs_nullable',1),(1263,'2021_09_20_183216_change_default_label_to_nullable',1),(1267,'2021_12_27_151849_change_supplier_address_length',1),(1271,'2022_01_10_182548_add_license_id_index_to_license_seats',1),(1275,'2022_02_03_214958_blank_out_ldap_active_flag',1),(1279,'2022_02_16_152431_add_unique_constraint_to_custom_field',1),(1283,'2022_03_03_225655_add_notes_to_accessories',1),(1287,'2022_03_03_225754_add_notes_to_components',1),(1291,'2022_03_03_225824_add_notes_to_consumables',1),(1295,'2022_03_04_080836_add_remote_to_user',1),(1299,'2022_03_09_001334_add_eula_to_checkout_acceptance',1),(1303,'2022_03_10_175740_add_eula_to_action_logs',1),(1307,'2022_03_21_162724_adds_ldap_manager',1),(1311,'2022_04_05_135340_add_primary_key_to_custom_fields_pivot',1),(1315,'2022_05_16_235350_remove_stored_eula_field',1),(1319,'2022_06_23_164407_add_user_id_to_users',1),(1323,'2022_06_28_234539_add_username_index_to_users',1),(1327,'2022_07_07_010406_add_indexes_to_license_seats',1),(1331,'2022_08_10_141328_add_notes_denorm_to_consumables_users',1),(1335,'2022_08_25_213308_adds_ldap_default_group_to_settings_table',1),(1339,'2022_09_29_040231_add_chart_type_to_settings',1),(1343,'2022_10_05_163044_add_start_termination_date_to_users',1),(1347,'2022_10_25_193823_add_externalid_to_users',1),(1351,'2022_11_07_134348_add_display_to_user_in_custom_fields',1),(1355,'2022_11_15_232525_adds_should_autoassign_bool_to_users_table',1),(1359,'2022_12_20_171851_fix_nullable_migration_for_settings',1),(1363,'2023_01_18_122534_add_byod_to_assets',1),(1367,'2023_01_21_225350_add_eol_date_on_assets_table',1),(1371,'2023_01_23_232933_add_vip_to_users',1),(1375,'2023_02_12_224353_fix_unescaped_customfields_format',1),(1379,'2023_02_28_173527_adds_webhook_option_to_settings_table',1),(1383,'2023_03_21_215218_update_slack_setting',1),(1385,'2022_10_25_215520_add_label2_settings',2),(1389,'2023_04_12_135822_add_supplier_to_components',2),(1393,'2023_04_25_085912_add_autoadd_to_customfields',2),(1397,'2023_04_25_181817_adds_ldap_location_to_settings_table',2),(1401,'2023_04_26_160235_add_warranty_url_to_manufacturers',2),(1405,'2023_05_08_132921_increase_state_to_more_than_3',2),(1409,'2023_05_10_001836_add_google_auth_to_settings',2),(1413,'2023_07_05_092237_change_settings_table_increase_saml_idp_metadata_size',2),(1417,'2023_07_06_092507_add_phone_fax_to_locations',2),(1421,'2023_07_13_052204_denormalized_eol_and_add_column_for_explicit_date_to_assets',2),(1425,'2023_07_14_004221_add_show_in_list_view_to_custom_fields',2),(1429,'2023_08_01_174150_change_webhook_settings_variable_type',2),(1433,'2023_08_13_172600_add_email_to_companies',2),(1437,'2023_08_17_202638_add_last_checkin_to_assets',2),(1441,'2023_08_21_064609_add_name_ordering_to_settings',2),(1445,'2023_08_21_181742_add_min_amt_to_models_table',2),(1449,'2023_09_13_200913_fix_asset_model_min_qty_nullability',2);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `models` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `model_number` varchar(191) DEFAULT NULL,
  `min_amt` int(11) DEFAULT NULL,
  `manufacturer_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `depreciation_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `eol` int(11) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `deprecated_mac_address` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `fieldset_id` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `requestable` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `models` WRITE;
/*!40000 ALTER TABLE `models` DISABLE KEYS */;
INSERT INTO `models` VALUES (1,'USB-C to USB-A converter',NULL,0,NULL,5,'2023-05-28 13:02:31','2023-05-29 08:42:24',NULL,NULL,0,NULL,0,NULL,7,NULL,0),(3,'4-Port USB3.0 Hub',NULL,0,NULL,5,'2023-05-29 06:21:08','2023-05-29 06:21:08',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(7,'the sssnake MC164 Multicore Bundle','198262',0,NULL,5,'2023-11-13 01:08:04','2023-11-13 01:08:04',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(10,'M5StickC Plus','M5StickC Plus',NULL,NULL,5,'2023-11-17 00:15:23','2023-11-17 00:15:23',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0),(11,'FlightCase V1','CC-000005',NULL,4,5,'2023-11-17 00:20:11','2023-11-17 00:20:11',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `models` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `models_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `models_custom_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_model_id` int(11) NOT NULL,
  `custom_field_id` int(11) NOT NULL,
  `default_value` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `models_custom_fields` WRITE;
/*!40000 ALTER TABLE `models_custom_fields` DISABLE KEYS */;
INSERT INTO `models_custom_fields` VALUES (7,1,5,'1999-10-12');
/*!40000 ALTER TABLE `models_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `secret` varchar(100) DEFAULT NULL,
  `provider` varchar(191) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES (3,NULL,'Snipe-IT Personal Access Client','PINNe1YlZoFXfLBGuwJoVNJLIwpPkO3HU96jSeXS',NULL,'http://localhost',1,0,0,'2023-05-28 12:00:21','2023-05-28 12:00:21'),(7,NULL,'Snipe-IT Password Grant Client','8UTM8wVDBjyOh6WgjgH4khRlEQFK0v9ICHKt5Utq','users','http://localhost',0,1,0,'2023-05-28 12:00:21','2023-05-28 12:00:21');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
INSERT INTO `oauth_personal_access_clients` VALUES (3,3,'2023-05-28 12:00:21','2023-05-28 12:00:21');
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `password_resets_email_index` (`email`),
  KEY `password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permission_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permission_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `permissions` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permission_groups` WRITE;
/*!40000 ALTER TABLE `permission_groups` DISABLE KEYS */;
INSERT INTO `permission_groups` VALUES (2,'CeltCaster','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"1\",\"assets.view\":\"1\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"1\",\"assets.checkout\":\"1\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"1\",\"accessories.view\":\"1\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"1\",\"accessories.checkin\":\"1\",\"accessories.files\":\"0\",\"consumables.view\":\"1\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"1\",\"consumables.files\":\"0\",\"licenses.view\":\"1\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"licenses.files\":\"0\",\"components.view\":\"1\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"1\",\"components.checkin\":\"1\",\"components.files\":\"0\",\"kits.view\":\"1\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"1\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"1\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"1\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\",\"self.view_purchase_cost\":\"0\"}','2023-05-29 06:58:16','2023-05-29 06:58:16'),(4,'Team Leads','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"1\",\"assets.create\":\"1\",\"assets.edit\":\"1\",\"assets.delete\":\"0\",\"assets.checkin\":\"1\",\"assets.checkout\":\"1\",\"assets.audit\":\"1\",\"assets.view.requestable\":\"1\",\"accessories.view\":\"1\",\"accessories.create\":\"1\",\"accessories.edit\":\"1\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"1\",\"accessories.checkin\":\"1\",\"accessories.files\":\"1\",\"consumables.view\":\"1\",\"consumables.create\":\"1\",\"consumables.edit\":\"1\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"1\",\"consumables.files\":\"1\",\"licenses.view\":\"1\",\"licenses.create\":\"1\",\"licenses.edit\":\"1\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"1\",\"licenses.keys\":\"1\",\"licenses.files\":\"1\",\"components.view\":\"1\",\"components.create\":\"1\",\"components.edit\":\"1\",\"components.delete\":\"0\",\"components.checkout\":\"1\",\"components.checkin\":\"1\",\"components.files\":\"1\",\"kits.view\":\"1\",\"kits.create\":\"1\",\"kits.edit\":\"1\",\"kits.delete\":\"0\",\"users.view\":\"1\",\"users.create\":\"1\",\"users.edit\":\"1\",\"users.delete\":\"0\",\"models.view\":\"1\",\"models.create\":\"1\",\"models.edit\":\"1\",\"models.delete\":\"0\",\"categories.view\":\"1\",\"categories.create\":\"1\",\"categories.edit\":\"1\",\"categories.delete\":\"0\",\"departments.view\":\"1\",\"departments.create\":\"1\",\"departments.edit\":\"1\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"1\",\"suppliers.create\":\"1\",\"suppliers.edit\":\"1\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"1\",\"manufacturers.create\":\"1\",\"manufacturers.edit\":\"1\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"1\",\"depreciations.create\":\"1\",\"depreciations.edit\":\"1\",\"depreciations.delete\":\"0\",\"locations.view\":\"1\",\"locations.create\":\"1\",\"locations.edit\":\"1\",\"locations.delete\":\"0\",\"companies.view\":\"1\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"1\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\",\"self.view_purchase_cost\":\"0\"}','2023-05-29 07:00:55','2023-05-29 07:00:55');
/*!40000 ALTER TABLE `permission_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `requested_assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `requested_assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `accepted_at` datetime DEFAULT NULL,
  `denied_at` datetime DEFAULT NULL,
  `notes` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `requested_assets` WRITE;
/*!40000 ALTER TABLE `requested_assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `requested_assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `requests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `request_code` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `requests` WRITE;
/*!40000 ALTER TABLE `requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `requests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `per_page` int(11) NOT NULL DEFAULT 20,
  `site_name` varchar(100) NOT NULL DEFAULT 'Snipe IT Asset Management',
  `qr_code` int(11) DEFAULT NULL,
  `qr_text` varchar(32) DEFAULT NULL,
  `display_asset_name` int(11) DEFAULT NULL,
  `display_checkout_date` int(11) DEFAULT NULL,
  `display_eol` int(11) DEFAULT NULL,
  `auto_increment_assets` int(11) NOT NULL DEFAULT 0,
  `auto_increment_prefix` varchar(191) DEFAULT NULL,
  `load_remote` tinyint(1) NOT NULL DEFAULT 1,
  `logo` varchar(191) DEFAULT NULL,
  `header_color` varchar(191) DEFAULT NULL,
  `alert_email` varchar(191) DEFAULT NULL,
  `alerts_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `default_eula_text` longtext DEFAULT NULL,
  `barcode_type` varchar(191) DEFAULT 'QRCODE',
  `webhook_endpoint` text DEFAULT NULL,
  `webhook_channel` varchar(191) DEFAULT NULL,
  `webhook_botname` varchar(191) DEFAULT NULL,
  `webhook_selected` varchar(191) DEFAULT 'slack',
  `default_currency` varchar(10) DEFAULT NULL,
  `custom_css` text DEFAULT NULL,
  `brand` tinyint(4) NOT NULL DEFAULT 1,
  `ldap_enabled` varchar(191) DEFAULT NULL,
  `ldap_server` varchar(191) DEFAULT NULL,
  `ldap_uname` varchar(191) DEFAULT NULL,
  `ldap_pword` longtext DEFAULT NULL,
  `ldap_basedn` varchar(191) DEFAULT NULL,
  `ldap_default_group` varchar(191) DEFAULT NULL,
  `ldap_filter` text DEFAULT NULL,
  `ldap_username_field` varchar(191) DEFAULT 'samaccountname',
  `ldap_lname_field` varchar(191) DEFAULT 'sn',
  `ldap_fname_field` varchar(191) DEFAULT 'givenname',
  `ldap_auth_filter_query` varchar(191) DEFAULT 'uid=',
  `ldap_version` int(11) DEFAULT 3,
  `ldap_active_flag` varchar(191) DEFAULT NULL,
  `ldap_dept` varchar(191) DEFAULT NULL,
  `ldap_emp_num` varchar(191) DEFAULT NULL,
  `ldap_email` varchar(191) DEFAULT NULL,
  `ldap_phone_field` varchar(191) DEFAULT NULL,
  `ldap_jobtitle` varchar(191) DEFAULT NULL,
  `ldap_manager` varchar(191) DEFAULT NULL,
  `ldap_country` varchar(191) DEFAULT NULL,
  `ldap_location` varchar(191) DEFAULT NULL,
  `full_multiple_companies_support` tinyint(1) NOT NULL DEFAULT 0,
  `ldap_server_cert_ignore` tinyint(1) NOT NULL DEFAULT 0,
  `locale` varchar(5) DEFAULT 'en',
  `labels_per_page` tinyint(4) NOT NULL DEFAULT 30,
  `labels_width` decimal(6,5) NOT NULL DEFAULT 2.62500,
  `labels_height` decimal(6,5) NOT NULL DEFAULT 1.00000,
  `labels_pmargin_left` decimal(6,5) NOT NULL DEFAULT 0.21975,
  `labels_pmargin_right` decimal(6,5) NOT NULL DEFAULT 0.21975,
  `labels_pmargin_top` decimal(6,5) NOT NULL DEFAULT 0.50000,
  `labels_pmargin_bottom` decimal(6,5) NOT NULL DEFAULT 0.50000,
  `labels_display_bgutter` decimal(6,5) NOT NULL DEFAULT 0.07000,
  `labels_display_sgutter` decimal(6,5) NOT NULL DEFAULT 0.05000,
  `labels_fontsize` tinyint(4) NOT NULL DEFAULT 9,
  `labels_pagewidth` decimal(7,5) NOT NULL DEFAULT 8.50000,
  `labels_pageheight` decimal(7,5) NOT NULL DEFAULT 11.00000,
  `labels_display_name` tinyint(4) NOT NULL DEFAULT 0,
  `labels_display_serial` tinyint(4) NOT NULL DEFAULT 1,
  `labels_display_tag` tinyint(4) NOT NULL DEFAULT 1,
  `alt_barcode` varchar(191) DEFAULT 'C128',
  `alt_barcode_enabled` tinyint(1) DEFAULT 1,
  `alert_interval` int(11) DEFAULT 30,
  `alert_threshold` int(11) DEFAULT 5,
  `name_display_format` varchar(10) DEFAULT 'first_last',
  `email_domain` varchar(191) DEFAULT NULL,
  `email_format` varchar(191) DEFAULT 'filastname',
  `username_format` varchar(191) DEFAULT 'filastname',
  `is_ad` tinyint(1) NOT NULL DEFAULT 0,
  `ad_domain` varchar(191) DEFAULT NULL,
  `ldap_port` varchar(5) NOT NULL DEFAULT '389',
  `ldap_tls` tinyint(1) NOT NULL DEFAULT 0,
  `zerofill_count` int(11) NOT NULL DEFAULT 5,
  `ldap_pw_sync` tinyint(1) NOT NULL DEFAULT 1,
  `two_factor_enabled` tinyint(4) DEFAULT NULL,
  `require_accept_signature` tinyint(1) NOT NULL DEFAULT 0,
  `date_display_format` varchar(191) NOT NULL DEFAULT 'Y-m-d',
  `time_display_format` varchar(191) NOT NULL DEFAULT 'h:i A',
  `next_auto_tag_base` bigint(20) NOT NULL DEFAULT 1,
  `login_note` text DEFAULT NULL,
  `thumbnail_max_h` int(11) DEFAULT 50,
  `pwd_secure_uncommon` tinyint(1) NOT NULL DEFAULT 0,
  `pwd_secure_complexity` varchar(191) DEFAULT NULL,
  `pwd_secure_min` int(11) NOT NULL DEFAULT 8,
  `audit_interval` int(11) DEFAULT NULL,
  `audit_warning_days` int(11) DEFAULT NULL,
  `show_url_in_emails` tinyint(1) NOT NULL DEFAULT 0,
  `custom_forgot_pass_url` varchar(191) DEFAULT NULL,
  `show_alerts_in_menu` tinyint(1) NOT NULL DEFAULT 1,
  `labels_display_company_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_archived_in_list` tinyint(1) NOT NULL DEFAULT 0,
  `dashboard_message` text DEFAULT NULL,
  `support_footer` char(5) DEFAULT 'on',
  `footer_text` text DEFAULT NULL,
  `modellist_displays` char(191) DEFAULT 'image,category,manufacturer,model_number',
  `login_remote_user_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `login_common_disabled` tinyint(1) NOT NULL DEFAULT 0,
  `login_remote_user_custom_logout_url` varchar(191) NOT NULL DEFAULT '',
  `skin` char(191) DEFAULT NULL,
  `show_images_in_email` tinyint(1) NOT NULL DEFAULT 1,
  `admin_cc_email` char(191) DEFAULT NULL,
  `labels_display_model` tinyint(1) NOT NULL DEFAULT 0,
  `privacy_policy_link` char(191) DEFAULT NULL,
  `version_footer` char(5) DEFAULT 'on',
  `unique_serial` tinyint(1) NOT NULL DEFAULT 0,
  `logo_print_assets` tinyint(1) NOT NULL DEFAULT 0,
  `depreciation_method` char(10) DEFAULT 'default',
  `favicon` char(191) DEFAULT NULL,
  `email_logo` char(191) DEFAULT NULL,
  `label_logo` char(191) DEFAULT NULL,
  `allow_user_skin` tinyint(1) NOT NULL DEFAULT 0,
  `show_assigned_assets` tinyint(1) NOT NULL DEFAULT 0,
  `login_remote_user_header_name` varchar(191) NOT NULL DEFAULT '',
  `ad_append_domain` tinyint(1) NOT NULL DEFAULT 0,
  `saml_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `saml_idp_metadata` mediumtext DEFAULT NULL,
  `saml_attr_mapping_username` varchar(191) DEFAULT NULL,
  `saml_forcelogin` tinyint(1) NOT NULL DEFAULT 0,
  `saml_slo` tinyint(1) NOT NULL DEFAULT 0,
  `saml_sp_x509cert` text DEFAULT NULL,
  `saml_sp_privatekey` text DEFAULT NULL,
  `saml_custom_settings` text DEFAULT NULL,
  `saml_sp_x509certNew` text DEFAULT NULL,
  `digit_separator` char(191) DEFAULT '1,234.56',
  `ldap_client_tls_cert` text DEFAULT NULL,
  `ldap_client_tls_key` text DEFAULT NULL,
  `dash_chart_type` varchar(191) DEFAULT 'name',
  `label2_enable` tinyint(1) NOT NULL DEFAULT 0,
  `label2_template` varchar(191) DEFAULT 'DefaultLabel',
  `label2_title` varchar(191) DEFAULT NULL,
  `label2_asset_logo` tinyint(1) NOT NULL DEFAULT 0,
  `label2_1d_type` varchar(191) NOT NULL DEFAULT 'default',
  `label2_2d_type` varchar(191) NOT NULL DEFAULT 'default',
  `label2_2d_target` varchar(191) NOT NULL DEFAULT 'hardware_id',
  `label2_fields` varchar(191) NOT NULL DEFAULT 'name=name;serial=serial;model=model.name;',
  `google_login` tinyint(1) DEFAULT 0,
  `google_client_id` varchar(191) DEFAULT NULL,
  `google_client_secret` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'2023-05-28 12:23:05','2023-11-17 00:23:55',1,200,'CeltTrack',1,'CeltTrack +31634096489',NULL,NULL,NULL,1,'CC-',1,'setting-logo-1-Pb7eouDOce.png','#7e9c54','tycho_w@celtcast.cema-ict.nl',1,NULL,'QRCODE',NULL,NULL,NULL,'slack','EUR','.main-footer, .hidden-print {\r\n    display: none !important;\r\n}\r\n\r\n@media only screen and (max-width: 470px) {\r\nform.navbar-form.navbar-left.form-horizontal .col-xs-12.col-md-12, form.navbar-form.navbar-left.form-horizontal .col-xs-12.col-md-12 .col-xs-12 {\r\n    padding-left: 0px;\r\n    padding-right: 0px;\r\n}\r\n\r\nform.navbar-form.navbar-left.form-horizontal {\r\n    padding: 0px 0px 0px 25px;\r\n    border: 0px;\r\n}\r\n\r\n.nav.navbar-nav li:not([aria-hidden=\"true\"]):not(.dropdown) {\r\n    width: 42%;\r\n}\r\n\r\n.nav.navbar-nav li.dropdown:not(.user-menu):not(.tasks-menu) {\r\n    width: 42%;\r\n    float: right;\r\n}\r\n\r\n.navbar-custom-menu ul.nav.navbar-nav li:last-child {\r\n    width: auto !important;\r\n}\r\n\r\nspan.select2.select2-container.select2-container--default {\r\n    /* width: auto !important; */\r\n    width: 75% !important;\r\n}\r\n\r\ndiv#assetsBulkEditToolbar {\r\n    min-width: 87vw !important;\r\n}\r\n}\r\n\r\n@media only screen and (min-width: 470px) and (max-width: 766px) {\r\nform.navbar-form.navbar-left.form-horizontal .col-xs-12.col-md-12, form.navbar-form.navbar-left.form-horizontal .col-xs-12.col-md-12 .col-xs-12 {\r\n    /* padding-left: 0px; */\r\n    /* padding-right: 0px; */\r\n}\r\n\r\nform.navbar-form.navbar-left.form-horizontal {\r\n    padding: 0px 0px 0px 25px;\r\n    border: 0px !important;\r\n}\r\n\r\n.nav.navbar-nav li:not([aria-hidden=\"true\"]):not(.dropdown) {\r\n    /* width: 42%; */\r\n}\r\n\r\n.nav.navbar-nav li.dropdown:not(.user-menu):not(.tasks-menu) {\r\n    /* width: 42%; */\r\n    /* float: right; */\r\n}\r\n\r\n.navbar-custom-menu ul.nav.navbar-nav li:last-child {\r\n    /* width: auto !important; */\r\n}\r\n\r\nspan.select2.select2-container.select2-container--default {\r\n    /* width: auto !important; */\r\n    width: 75% !important;\r\n}\r\n\r\ndiv#assetsBulkEditToolbar {\r\n    min-width: 87vw !important;\r\n}\r\n}',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'samaccountname','sn','givenname','uid=',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,'nl',1,3.70000,1.00000,0.00000,0.00000,0.00000,0.00000,0.07000,0.05000,10,8.50000,11.00000,1,1,1,'C128',0,30,5,'first_last','celtcast.cema-ict.nl','firstname.lastname','filastname',0,NULL,'389',0,6,1,NULL,0,'Y-m-d','H:i',6,NULL,50,0,NULL,10,NULL,NULL,0,NULL,1,1,0,NULL,'off',NULL,'image,category,manufacturer,model_number',0,0,'','black',1,NULL,0,NULL,'off',1,1,'default','favicon-uploaded.png','setting-email_logo-1-uljYrTJEGy.png','setting-label_logo-1-oxxVGqO5lA.png',0,1,'',0,0,NULL,NULL,0,0,NULL,NULL,NULL,NULL,'1,234.56',NULL,NULL,'name',0,'DefaultLabel',NULL,0,'default','default','hardware_id','name=name;serial=serial;model=model.name;',0,NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `status_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `status_labels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `deployable` tinyint(1) NOT NULL DEFAULT 0,
  `pending` tinyint(1) NOT NULL DEFAULT 0,
  `archived` tinyint(1) NOT NULL DEFAULT 0,
  `notes` text DEFAULT NULL,
  `color` varchar(10) DEFAULT NULL,
  `show_in_nav` tinyint(1) DEFAULT 0,
  `default_label` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `status_labels` WRITE;
/*!40000 ALTER TABLE `status_labels` DISABLE KEYS */;
INSERT INTO `status_labels` VALUES (3,'In behandeling (AUDIT)',1,NULL,'2023-05-29 06:44:37',NULL,0,1,0,'These assets are not yet ready to be deployed, usually because of configuration or waiting on parts.','#ffce53',0,0),(7,'Gereed',1,NULL,'2023-11-13 01:04:03',NULL,1,0,0,'These assets are ready to deploy.','#aa3399',1,1),(11,'Gearchiveerd',1,NULL,'2023-05-29 06:21:30',NULL,0,0,1,'These assets are no longer in circulation or viable.','#aa3399',0,0),(12,'Reparatie',NULL,'2023-05-28 13:47:54','2023-05-29 06:51:16',NULL,0,1,0,NULL,'#db4545',1,1),(16,'Vermist',5,'2023-05-29 06:43:13','2023-05-29 06:43:13',NULL,0,0,1,'Dit Item is gemarkeerd als vermist.','#000000',1,1),(20,'Eigen Gebruik',5,'2023-05-29 06:48:23','2023-05-29 06:48:23',NULL,0,0,0,'In gebruik door een CeltCaster','#ffb800',1,1),(24,'Uitgegeven',5,'2023-05-29 06:50:09','2023-05-29 06:50:51',NULL,1,0,0,'On the Road with them Items!','#5d77ff',1,1);
/*!40000 ALTER TABLE `status_labels` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `address` varchar(250) DEFAULT NULL,
  `address2` varchar(250) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(2) DEFAULT NULL,
  `phone` varchar(35) DEFAULT NULL,
  `fax` varchar(35) DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `contact` varchar(100) DEFAULT NULL,
  `notes` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
INSERT INTO `suppliers` VALUES (2,'Action',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-05-29 06:01:03','2023-05-29 06:01:03',NULL,NULL,NULL,NULL,NULL),(6,'Lea-Inc','Vrouwe Machteldweg 18',NULL,'Oostvoorne',NULL,'NL','+31636446351',NULL,'hannah.isabella.schotte@gmail.com','Hannah Isabella Schotte',NULL,'2023-11-13 01:02:49','2023-11-13 01:02:49',5,NULL,'3233TW','https://lea-inc.nl',NULL),(10,'VNG Systems',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-17 00:18:09','2023-11-17 00:18:09',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `throttle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `throttle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `suspended` tinyint(1) NOT NULL DEFAULT 0,
  `banned` tinyint(1) NOT NULL DEFAULT 0,
  `last_attempt_at` timestamp NULL DEFAULT NULL,
  `suspended_at` timestamp NULL DEFAULT NULL,
  `banned_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `throttle_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `throttle` WRITE;
/*!40000 ALTER TABLE `throttle` DISABLE KEYS */;
/*!40000 ALTER TABLE `throttle` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) DEFAULT NULL,
  `password` varchar(191) NOT NULL,
  `permissions` text DEFAULT NULL,
  `activated` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) DEFAULT NULL,
  `activation_code` varchar(191) DEFAULT NULL,
  `activated_at` timestamp NULL DEFAULT NULL,
  `last_login` timestamp NULL DEFAULT NULL,
  `persist_code` varchar(191) DEFAULT NULL,
  `reset_password_code` varchar(191) DEFAULT NULL,
  `first_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `gravatar` varchar(191) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `jobtitle` varchar(191) DEFAULT NULL,
  `manager_id` int(11) DEFAULT NULL,
  `employee_num` text DEFAULT NULL,
  `avatar` varchar(191) DEFAULT NULL,
  `username` varchar(191) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `remember_token` text DEFAULT NULL,
  `ldap_import` tinyint(1) NOT NULL DEFAULT 0,
  `locale` varchar(10) DEFAULT 'en',
  `show_in_list` tinyint(1) NOT NULL DEFAULT 1,
  `two_factor_secret` varchar(32) DEFAULT NULL,
  `two_factor_enrolled` tinyint(1) NOT NULL DEFAULT 0,
  `two_factor_optin` tinyint(1) NOT NULL DEFAULT 0,
  `department_id` int(11) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `skin` varchar(191) DEFAULT NULL,
  `remote` tinyint(1) DEFAULT 0,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `scim_externalid` varchar(191) DEFAULT NULL,
  `autoassign_licenses` tinyint(1) NOT NULL DEFAULT 1,
  `vip` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `users_activation_code_index` (`activation_code`),
  KEY `users_reset_password_code_index` (`reset_password_code`),
  KEY `users_company_id_index` (`company_id`),
  KEY `users_username_deleted_at_index` (`username`,`deleted_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='$2y$10$oqPPQmOX6xCmUicMdvAQiOg0PQqljMPjD491XgdG3/uOce8dQnf5G';
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'tycho.werner@celtcast.com','$2y$10$oqPPQmOX6xCmUicMdvAQiOg0PQqljMPjD491XgdG3/uOce8dQnf5G','{\"superuser\":\"1\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"assets.view.encrypted_custom_fields\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"accessories.files\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"consumables.files\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"licenses.files\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"components.files\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\",\"self.view_purchase_cost\":\"0\"}',1,NULL,NULL,NULL,'2024-05-13 05:52:35',NULL,NULL,'Tycho','Werner','2023-05-28 12:23:05','2024-05-13 05:54:40',NULL,NULL,'NL',NULL,2,NULL,NULL,NULL,NULL,NULL,'tycho.werner',NULL,2,'7tRz0BhUI13rNuPHSrrxDPYGISrSAhVdqMtTUm2yAENP5SjPxiQtDq7JcVek',0,'nl',1,NULL,0,0,4,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,1,0),(5,'hannah.schotte@celtcast.com','$2y$10$oqPPQmOX6xCmUicMdvAQiOg0PQqljMPjD491XgdG3/uOce8dQnf5G','{\"superuser\":\"1\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"accessories.files\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"consumables.files\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"licenses.files\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"components.files\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\",\"self.view_purchase_cost\":\"0\"}',1,NULL,NULL,NULL,'2023-11-23 21:41:52',NULL,NULL,'Hannah','Schotte','2023-05-28 12:58:43','2023-11-23 21:41:52',NULL,'https://lea-inc.nl','NL',NULL,NULL,'+31636446351','Videograaf',1,NULL,'user-avatar-5-eFzqXRWc3l.png','hschotte',NULL,2,'BFzqfYpwe5jY88KbhkQNM4UcVaqoSJSQDDMUcRE7u326uZLu7G3oRr1mvcI3',0,'nl',1,NULL,0,0,4,'Vrouwe Machteldweg 18','Oostvoorne',NULL,'3233TW',NULL,0,NULL,NULL,NULL,1,0),(6,'hannah.schotte@celtcast.com','$2y$10$ZseIUA8yUv.7s7O3z0aNzOmAPwFOw.6G9MugfaGvM1WIQVxcghjfq','{\"superuser\":\"0\",\"admin\":\"0\",\"import\":\"0\",\"reports.view\":\"0\",\"assets.view\":\"0\",\"assets.create\":\"0\",\"assets.edit\":\"0\",\"assets.delete\":\"0\",\"assets.checkin\":\"0\",\"assets.checkout\":\"0\",\"assets.audit\":\"0\",\"assets.view.requestable\":\"0\",\"accessories.view\":\"0\",\"accessories.create\":\"0\",\"accessories.edit\":\"0\",\"accessories.delete\":\"0\",\"accessories.checkout\":\"0\",\"accessories.checkin\":\"0\",\"accessories.files\":\"0\",\"consumables.view\":\"0\",\"consumables.create\":\"0\",\"consumables.edit\":\"0\",\"consumables.delete\":\"0\",\"consumables.checkout\":\"0\",\"consumables.files\":\"0\",\"licenses.view\":\"0\",\"licenses.create\":\"0\",\"licenses.edit\":\"0\",\"licenses.delete\":\"0\",\"licenses.checkout\":\"0\",\"licenses.keys\":\"0\",\"licenses.files\":\"0\",\"components.view\":\"0\",\"components.create\":\"0\",\"components.edit\":\"0\",\"components.delete\":\"0\",\"components.checkout\":\"0\",\"components.checkin\":\"0\",\"components.files\":\"0\",\"kits.view\":\"0\",\"kits.create\":\"0\",\"kits.edit\":\"0\",\"kits.delete\":\"0\",\"users.view\":\"0\",\"users.create\":\"0\",\"users.edit\":\"0\",\"users.delete\":\"0\",\"models.view\":\"0\",\"models.create\":\"0\",\"models.edit\":\"0\",\"models.delete\":\"0\",\"categories.view\":\"0\",\"categories.create\":\"0\",\"categories.edit\":\"0\",\"categories.delete\":\"0\",\"departments.view\":\"0\",\"departments.create\":\"0\",\"departments.edit\":\"0\",\"departments.delete\":\"0\",\"statuslabels.view\":\"0\",\"statuslabels.create\":\"0\",\"statuslabels.edit\":\"0\",\"statuslabels.delete\":\"0\",\"customfields.view\":\"0\",\"customfields.create\":\"0\",\"customfields.edit\":\"0\",\"customfields.delete\":\"0\",\"suppliers.view\":\"0\",\"suppliers.create\":\"0\",\"suppliers.edit\":\"0\",\"suppliers.delete\":\"0\",\"manufacturers.view\":\"0\",\"manufacturers.create\":\"0\",\"manufacturers.edit\":\"0\",\"manufacturers.delete\":\"0\",\"depreciations.view\":\"0\",\"depreciations.create\":\"0\",\"depreciations.edit\":\"0\",\"depreciations.delete\":\"0\",\"locations.view\":\"0\",\"locations.create\":\"0\",\"locations.edit\":\"0\",\"locations.delete\":\"0\",\"companies.view\":\"0\",\"companies.create\":\"0\",\"companies.edit\":\"0\",\"companies.delete\":\"0\",\"self.two_factor\":\"0\",\"self.api\":\"0\",\"self.edit_location\":\"0\",\"self.checkout_assets\":\"0\",\"self.view_purchase_cost\":\"0\"}',1,5,NULL,NULL,'2023-05-29 07:25:09',NULL,NULL,'Test User','Hannah','2023-05-29 07:22:07','2023-05-29 07:25:09',NULL,NULL,'NL',NULL,13,NULL,'Test CeltCaster',5,NULL,NULL,'debug','Dit is een test Account,\r\nhet wachtwoord is: CeltCastDebug123',2,'aYOAeMnqRlVnwF0mZTGT0mY6Dw8H6b2D4w1ROZ8HdM1m01guxaHAc442Bshu',0,NULL,1,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,1,0);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users_groups` (
  `user_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users_groups` WRITE;
/*!40000 ALTER TABLE `users_groups` DISABLE KEYS */;
INSERT INTO `users_groups` VALUES (1,4),(5,2),(6,2);
/*!40000 ALTER TABLE `users_groups` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

